/** @odoo-module **/
import { jsonrpc } from "@web/core/network/rpc_service";
import publicWidget from "@web/legacy/js/public/public_widget";
import animations from "@website/js/content/snippets.animation";
publicWidget.registry.BestDeal = animations.Animation.extend({
 // To extend public widget
        selector: '.best_deal',
         start: async function () {
          // To get data from controller.
        var self = this;
        await jsonrpc('/get_product', {}).then(function(data) {
            if (data) {
                       self.$target.html(data)
                    }
        });
        await jsonrpc('/get_countdown', {}).then(function(data) {
            if (data) {
            var end_date = new Date(data).getTime();
                        var days, hours, minutes, seconds;
                        setInterval(function() {
                            var start_date = new Date().getTime();
                            var seconds_left = (end_date - start_date) / 1000;
                            days = parseInt(seconds_left / 86400);
                            seconds_left = seconds_left % 86400;
                            hours = parseInt(seconds_left / 3600);
                            seconds_left = seconds_left % 3600;
                            minutes = parseInt(seconds_left / 60);
                            seconds = parseInt(seconds_left % 60);
                            this.$("#countdown").html('<span class="days">' + days +
                                ' <label>Days</label></span> <span class="hours">' + hours +
                                ' <label>Hours</label></span> <span class="minutes">' +
                                minutes + ' <label>Minutes</label></span> <span class="seconds">' + seconds + ' <label>Seconds</label></span>');
                        }, 1000);
            }
    })
 }
})
