# Copyright 2016 ACSONE SA/NV (https://acsone.eu)
# Copyright 2016 Akretion (Alexis de Lattre alexis.delattre@akretion.com)
# Copyright 2018 Simone Rubino - Agile Business Group
# License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl).

from odoo import api, fields, _
from odoo.exceptions import UserError
from odoo import models


class BaseModel(models.AbstractModel):
    _inherit = 'base'

    @api.model
    def name_create(self, name):
        model = self.env['ir.model'].search([('model', '=', self._name)])
        if model.avoid_quick_create:
            raise UserError(
                _(
                    "Can't create %(model)s with name %(name)s quickly.\n"
                    "Please contact your system administrator to disable "
                    "this behaviour."
                )
                % {"model": self._name, "name": name}
            )
        res = super().name_create(name)
        return res


class IrModel(models.Model):
    _inherit = "ir.model"

    avoid_quick_create = fields.Boolean()
