# Copyright 2016 ACSONE SA/NV (https://acsone.eu)
# Copyright 2016 Akretion (Alexis de Lattre alexis.delattre@akretion.com)
# Copyright 2018 Simone Rubino - Agile Business Group
# License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl).

from odoo import api, models, _
from odoo.exceptions import UserError


class ResPartner(models.Model):
    """Inheriting res_partner to super name_create()"""
    _inherit = "res.partner"

    @api.model
    def name_create(self, name):
        """Check avoid_quick_create field in ir_model for res_partner"""
        model = self.env['ir.model'].search([('model', '=', self._name)])
        if model.avoid_quick_create:
            raise UserError(
                _(
                    "Can't create %(model)s with name %(name)s quickly.\n"
                    "Please contact your system administrator to disable "
                    "this behaviour."
                )
                % {"model": self._name, "name": name}
            )
        else:
            return super().name_create(name)
