# Copyright 2016 ABF OSIELL <http://osiell.com>
# Copyright 2018 Tecnativa - Cristina Martin R.
# License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl).

from odoo import fields, models


class ResConfigSettings(models.TransientModel):
    """Add a new feature in settings google tag manager boolean field and add a
    char field for enter container ID"""

    _inherit = 'res.config.settings'
    _description = 'inherit model res.config.settings and add fields'

    google_tag_manager = (
        fields.Boolean(string="Google Tag Manager", default=False,
                       help="Enable to give access to google tag manager",
                       config_parameter="google_tag_manager.google_tag_manager"))
    container_id = fields.Char(string="Container ID", default=False,
                               help="Container id of google tag manager",
                               config_parameter=
                               "google_tag_manager.container_id")
