/** @odoo-module **/
/* Copyright 2023 Camptocamp - Telmo Santos
 * License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl). */
import { SwitchCompanyMenu } from "@web/webclient/switch_company_menu/switch_company_menu";
import { browser } from "@web/core/browser/browser";
import { patch } from "@web/core/utils/patch";
import { useState } from "@odoo/owl";

patch(SwitchCompanyMenu.prototype,  {
    setup() {
        super.setup(...arguments);
        this.allCompanyIds = Object.values(this.companyService.allowedCompanies).map(
            (x) => x.id
        );
        this.isAllCompaniesSelected = this.allCompanyIds.every((elem) =>
            this.companySelector.selectedCompaniesIds.includes(elem)
        );
        this.state = useState({ companiesToToggle: [] });
    },
    toggleSelectAllCompanies() {
        if (this.isAllCompaniesSelected) {
            // Deselect all
            this.state.companiesToToggle = [this.companyService.currentCompany.id]
            this.isAllCompaniesSelected = false;
            browser.clearTimeout(this.toggleTimer);
            this.toggleTimer = browser.setTimeout(() => {
                this.companyService.setCompanies(
                    this.state.companiesToToggle,"loginto",
                );
            }, this.constructor.toggleDelay);
        } else {
            // Select all
            this.state.companiesToToggle = this.allCompanyIds;
            this.isAllCompaniesSelected = true;
            browser.clearTimeout(this.toggleTimer);
            this.toggleTimer = browser.setTimeout(() => {
                this.companyService.setCompanies(
                    this.state.companiesToToggle, "loginto"
                );
            }, this.constructor.toggleDelay);
        }
    },
});

