# -*- coding: utf-8 -*-
from odoo import models


class IrHttp(models.AbstractModel):
    _inherit = 'ir.http'

    def session_info(self):
        res = super(IrHttp, self).session_info()
        recent_app = self.env['recent.apps'].sudo()
        pinned_menu = self.env['pinned.menu'].sudo()
        res['is_auto_edit'] = self.env.user.auto_edit
        res['recent_app'] = recent_app.search_read([
            ('user_id', '=', self.env.uid)], ["app_id", "name"],
            order="create_date DESC")
        res['pinned_menu'] = pinned_menu.search_read([
            ('user_id', '=', self.env.uid)], ["app_id", "name"],
            order="create_date DESC")
        return res
