# -*- coding: utf-8 -*-
from odoo import api, fields, models


class PinnedMenu(models.Model):
    _name = 'pinned.menu'
    _description = 'Pinned Menu'

    name = fields.Char(compute='_compute_name', store=True)
    app_id = fields.Integer()
    user_id = fields.Many2one('res.users')

    @api.depends('app_id')
    def _compute_name(self):
        menu_ui = self.env['ir.ui.menu']
        for rec in self:
            app = menu_ui.browse(rec.app_id)
            rec.name = app.name

    @api.model
    def unpin_menu(self, app_id):
        self.search([
            ("app_id", "=", app_id), ("user_id", "=", self.env.uid)
        ]).unlink()
