# -*- coding: utf-8 -*-
from odoo import api, models


class RecentApps(models.Model):
    _name = 'recent.apps'
    _inherit = 'pinned.menu'
    _description = 'Recent Apps'

    @api.model
    def create(self, val_list):
        rec_ids = self.search([("user_id", "=", val_list["user_id"])],
                              order="create_date DESC")
        if val_list["app_id"] in rec_ids.mapped("app_id"):
            rec_ids.browse(val_list["app_id"]).unlink()
        res = super(RecentApps, self).create(val_list)
        if len(rec_ids) > 4:
            rec_ids[4:].unlink()
        return res
