# -*- coding: utf-8 -*-
from odoo import fields, models


class AddToShortcut(models.Model):
    _name = 'shortcut.menu'
    _description = 'Shortcut Menus'

    name = fields.Char('Name')
    res_model = fields.Many2one('ir.model', 'Model')
    window_action_id = fields.Many2one('ir.actions.act_window')
    client_action_id = fields.Many2one('ir.actions.client')
    server_action_id = fields.Many2one('ir.actions.server')
    menu_id = fields.Many2one('ir.ui.menu')
    xml_id = fields.Char(
        string='External ID', related='window_action_id.xml_id', store=True)
    model = fields.Char(related='window_action_id.res_model')
    path = fields.Char('Path')
    view_type = fields.Char('View Type')
