# -*- coding: utf-8 -*-
###############################################################################
#
#    Cyllo
#
#    Copyright (C) 2023-TODAY Cyllo(<https://www.cyllo.com>)
#    Author:  Mruthul Raj
#
#    You can modify it under the terms of the GNU AFFERO
#    GENERAL PUBLIC LICENSE (AGPL v3), Version 3.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU AFFERO GENERAL PUBLIC LICENSE (AGPL v3) for more details.
#
#    You should have received a copy of the GNU AFFERO GENERAL PUBLIC LICENSE
#    (AGPL v3) along with this program.
#    If not, see <http://www.gnu.org/licenses/>.
#
###############################################################################
from odoo import fields, models


class AllowedIPs(models.Model):
    """Class for the model allowed_ips. Contains fields for record users and
    their Allowed IPs."""
    _name = 'allowed.ips'
    _description = "Allowed IPs"

    user_ip_id = fields.Many2one('res.users', string='User',
                                 help='User associated with the allowed IP')
    ip_address = fields.Char(string='Allowed IP', help='The allowed IP address'
                                                       ' for the User.')
